//---------------------------------------------------------------------------
#ifndef randomH
#define randomH
//---------------------------------------------------------------------------
// names of header files may differ
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <mem.h>
#include <stdlib.h>
#include <assert.h>
//---------------------------------------------------------------------------
// define if you want self-test:
//#define SELF_TEST

// define 32-bits unsigned integer
typedef unsigned long uint32;
//---------------------------------------------------------------------------
// If your system doesn't have a rotate function for 32 bits integers,
// then define it thus:
// uint32 _lrotl (uint32 x, int r) {
//   return (x << r) | (x >> (sizeof(x)*8-r));}
//---------------------------------------------------------------------------
// define parameters
const int KK = 17;
const int JJ = 10;
const int R1 = 13;
const int R2 =  9;
//---------------------------------------------------------------------------
class TRanrotBGenerator {             // encapsulate random number generator
  public:
  void RandomInit(uint32 seed);       // initialization
  void SetInterval(int min, int max); // set interval for iRandom
  int iRandom();                      // get integer random number
  double Random();                    // get floating point random number
  TRanrotBGenerator(uint32 seed=-1);  // constructor
  protected:
  int p1, p2;                         // indexes into buffer
  int imin, iinterval;                // interval for iRandom
  uint32 randbuffer[KK];              // history buffer
#ifdef SELF_TEST
  uint32 randbufcopy[KK*2];           // used for self-test
#endif
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
