//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "main.h"
#include "about.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::cmdMakePasswordClick(TObject *Sender)
{
   int iNumChars;
   char *ThePassword;

   iNumChars = atoi(txtNumChars->Text.c_str());
   if (iNumChars < 1)
   {
      Application->MessageBoxA("Password must contain at least 1 character!","Error",MB_ICONERROR);
      txtNumChars->SetFocus();
      txtNumChars->Text = "0";
      txtNumChars->SelectAll();
      return;
   }

   // Allocate memory for the password.
   ThePassword = new char[iNumChars + 1];

   // Build the password by selecting random numbers from the array of numbers.
   for (int i = 0; i < iNumChars; i++)
   {
      if (i == 0)
         strcpy(ThePassword, TheChars[TheNumbers[rng.iRandom()]]);
      else
         strcat(ThePassword, TheChars[TheNumbers[rng.iRandom()]]);

   }

   // Display the password and clean up.
   txtPassword->Text = ThePassword;
   delete ThePassword;

}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
   // Initialize the random number generator for the array of numbers.
   rng.RandomInit(time(0));
   rng.SetInterval(0,61);

   // Initialize the array of numbers.
   for (int i = 0; i < 62; i++)
      TheNumbers[i] = i;


   // Randomize the array pf numbers.

      iCurrentNumber = rng.iRandom();
      while (iCurrentNumber == iNewNumber)
         iCurrentNumber = rng.iRandom();
      iNewNumber = rng.iRandom();
      while (iNewNumber == iCurrentNumber)
         iNewNumber = rng.iRandom();
      iTemp = TheNumbers[iCurrentNumber];
      TheNumbers[iCurrentNumber] = TheNumbers[iNewNumber];
      TheNumbers[iNewNumber] = iTemp;


   AppendMenu(GetSystemMenu(Handle, FALSE), MF_SEPARATOR, 0, "");
   AppendMenu(GetSystemMenu(Handle, FALSE), MF_STRING, PASSWORD_ABOUT,"&About");

}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::FormActivate(TObject *Sender)
{
   txtNumChars->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::ShowAbout(TMessage & Msg)
{
    switch(Msg.WParam)
    {
       case PASSWORD_ABOUT :
          frmAbout = new TfrmAbout(this);
          frmAbout->ShowModal();
          delete frmAbout;
          Msg.Result = 0;
          break;
       case SC_MINIMIZE :
          Application->Minimize();
          break;
       case SC_RESTORE :
          Application->Restore();
       default :
          DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
    }

}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::FormResize(TObject *Sender)
{
  txtPassword->Left = 24;
  txtPassword->Width = ClientWidth - txtPassword->Left - 24;
  cmdMakePassword->Left = ClientWidth - cmdMakePassword->Width - 24;
}
//---------------------------------------------------------------------------

